package com.androidbook.commoncontrols;

import android.app.Activity;
import android.os.Bundle;
import android.widget.DatePicker;
import android.widget.TextView;
import android.widget.TimePicker;

public class DateTimePickerActivity extends Activity {
	/** Wywoywane podczas pierwszego utworzenia aktywnoci. */
    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.datetimepicker);
	        
        TextView dateDefault = (TextView)findViewById(R.id.dateDefault);
        TextView timeDefault = (TextView)findViewById(R.id.timeDefault);
	        
        DatePicker dp = (DatePicker)this.findViewById(R.id.datePicker);
        // Tylko i wycznie warto miesica jest liczona od zera. Dodajmy 1, aby wywietli waciw warto.
        dateDefault.setText("Domylna data " + (dp.getMonth() + 1) + "/" +
        		dp.getDayOfMonth() + "/" + dp.getYear());
        // A tutaj musimy od wartoci Grudzie (12) odj 1, aby uzyska waciwy wynik.
        dp.init(2008, 11, 10, null);

        TimePicker tp = (TimePicker)this.findViewById(R.id.timePicker);

        java.util.Formatter timeF = new java.util.Formatter();
        timeF.format("Domylny czas: %d:%02d", tp.getCurrentHour(),
                        tp.getCurrentMinute());
        timeDefault.setText(timeF.toString());
	        
        tp.setIs24HourView(true);
        tp.setCurrentHour(new Integer(10));
        tp.setCurrentMinute(new Integer(10));
    }
}
